
#include <e32keys.h>

#include <coemain.h>

#include <eikenv.h>
#include <eikdef.h>
#include <eikcmds.hrh>
#include <eiklabel.h>
#include <eikcfdlg.h>
#include <eikon.rsg>
#include <eiktbar.h>
#include <eikcmbut.h>
#include <d32snd.h>

#include <psiapple.rsg>
#include "psiapple.hrh"
#include "ap2gui.h"

#include "ap2view.h"
#include "AppleDiskII.h"

//
// CAppleIICPURunner
//

CAppleIICPURunner::CAppleIICPURunner(TAppleII* aModel) : iModel(aModel) 
{ 
	iSoundAlert = 0;
	iVolume = EVolumeNone;
	iCPUTimer = NULL;
#ifdef __GNUC__
	iTicksPerSec = 8000/SAMPLES_PER_FRAGMENT;
#else
	iTicksPerSec = 10;
#endif
}

CAppleIICPURunner::~CAppleIICPURunner()
{
	Stop();
}

void CAppleIICPURunner::Start(TInt aClockSpeed)
{
	Stop();
	iClockSpeed = aClockSpeed;
	iPeriod = 1000000/iTicksPerSec;
	iCyclesPerTick = iClockSpeed/iTicksPerSec;
	iCPUTimer=CPeriodic::NewL(0); // neutral priority
	iCPUTimer->Start(iPeriod, iPeriod, TCallBack(Tick, this));
	SetSound(EVolumeSoft);
}

void CAppleIICPURunner::Stop()
{
	if (iCPUTimer)
	{
		iCPUTimer->Cancel();
		delete iCPUTimer;
		iCPUTimer = NULL;
	}
	SetSound(EVolumeNone);
}

void CAppleIICPURunner::SetSound(TSoundVolume aVolume)
{
	if (aVolume == EVolumeNone && iVolume != EVolumeNone)
	{
		iSpeaker.Close();
		iModel->setSoundListener(NULL);
	}
	if (aVolume != EVolumeNone && iVolume == EVolumeNone)
	{
		iSpeaker.Open();
	}
	iVolume = aVolume;
	if (iVolume != EVolumeNone)
	{
		iSpeaker.ChangeVolume(iVolume);
		iModel->setSoundListener(this);
	}
}

void CAppleIICPURunner::soundChanged(int clock, int newstate)
{
	iSoundAlert = 2;
}

// private
TInt CAppleIICPURunner::Tick(TAny* aObject)
	{
    ((CAppleIICPURunner*)aObject)->DoTick(); // cast, and call non-static func
    return 1;
    }

void CAppleIICPURunner::DoTick()
{	
	if (iVolume != EVolumeNone)
	{
		TInt iCyclesPerSample = iCyclesPerTick/SAMPLES_PER_FRAGMENT;
		TInt iInitialSndstate = iModel->getSoundstate();
		TInt iSamp;
		for (iSamp=0; !iSoundAlert && iSamp<SAMPLES_PER_FRAGMENT; iSamp+=8)
		{
			iModel->execute(iCyclesPerSample*8);
		}
		for (; iSamp<SAMPLES_PER_FRAGMENT; iSamp++)
		{
			iModel->execute(iCyclesPerSample);
			iSpeaker.AddSample(iSamp, iModel->getSoundstate());
		}
		if ( iSpeaker.SamplesWereAdded() )
		{
			iSpeaker.PlayFragment();
		}
		if (iSoundAlert)
			iSoundAlert--;
	} else {
		iModel->execute(iCyclesPerTick);
	}
}

//
// CAppleIIAppView
//

void CAppleIIAppView::ConstructL(const TRect& aRect, TAppleII* aModel)
    {
	iModel=aModel;
	iLastMarkClock = 0;
    CreateWindowL();
    Window().SetShadowDisabled(ETrue);
    iContext=this;
   	iBrushStyle=CGraphicsContext::ESolidBrush;
    iBrushColor=KRgbWhite;
    SetRectL(aRect);
	CreateLabelL();
	ConstructViewL();
	iBackgroundBitmap = new (ELeave) CFbsBitmap();
	User::LeaveIfError(iBackgroundBitmap->Load(
		_L("c:\\system\\apps\\psiapple\\applebkg.mbm")));
    ActivateL();
    }

CAppleIIAppView::~CAppleIIAppView()
    {
	StopUpdate();
	if (iView)
		delete iView;
	if (iBackgroundBitmap)
		delete iBackgroundBitmap;
	delete iLabel;
    }

void CAppleIIAppView::StopUpdate()
{
	if (iRefreshTimer)
	{
		iRefreshTimer->Cancel();
		delete iRefreshTimer;
		iRefreshTimer = NULL;
	}
}

void CAppleIIAppView::StartUpdate(TInt aInterval)
{
	StopUpdate();
	iRefreshInterval = aInterval;
	iRefreshTimer=CPeriodic::NewL(0); // neutral priority
	iRefreshTimer->Start(iRefreshInterval, iRefreshInterval, TCallBack(Tick, this));
}

// private
TInt CAppleIIAppView::Tick(TAny* aObject)
    {
    ((CAppleIIAppView*)aObject)->DoTick(); // cast, and call non-static func
    return 1;
    }

void CAppleIIAppView::DoTick()
{	
	if (iView) 
	{
		TInt linesRendered = iView->Render();
		if (linesRendered > 0)
		{
			iView->DrawNow();
			/*
			TBuf<64> tgt;
			tgt.Format(_L("drawing %d @ %x"), linesRendered, iModel->getState()->getClock());
			NotifyStatus(tgt);
			*/
		}
	}

	TInt curclock = iModel->getState()->getClock();
	if (curclock-iLastMarkClock > 3000000)
	{
		TTime curtime;
		curtime.UniversalTime();
		TInt64 timel = curtime.MicroSecondsFrom(iLastMarkTime).Int64();
		float avgclkrate = ((curclock-iLastMarkClock)*1.0f)/timel.GetTInt();
		TBuf<32> tgt;
		tgt.Format(_L("%5.3f MHz"), avgclkrate);
		NotifyStatus(tgt);
		iLastMarkTime = curtime;
		iLastMarkClock = curclock;
	}
}
    
TInt CAppleIIAppView::CountComponentControls() const
	{
	return 1 + (iView ? 1 : 0); // always a label, sometimes a view
	}

CCoeControl* CAppleIIAppView::ComponentControl(TInt aIndex) const
	{
	switch (aIndex)
		{
	case 0: return iLabel;
	case 1: return iView;
	default: return 0;
		};
	}

const TInt KLabelHeight=20;

void CAppleIIAppView::CreateLabelL()
	{
	iLabel=new (ELeave) CEikLabel;
	/*
	TRect rect=Rect();
	rect.iTl.iY=rect.iBr.iY-KLabelHeight; // make it bottom 20 pixels
	*/
	TRect rect(442, 32, 448+80, 32+16);

	// get font for this label
	/*
	TFontSpec iFontSpec(_L("Swiss"),100);
	CGraphicsDevice* screenDevice=(ControlEnv()->ScreenDevice());
    screenDevice->GetNearestFontInTwips(iLabelFont,iFontSpec);
	iLabel->SetFont(iLabelFont);
	*/

	iLabel->SetContainerWindowL(*this);
	iLabel->SetRectL(rect);
	iLabel->SetAlignment(EHCenterVCenter); // center text
	iLabel->SetBufferReserveLengthL(200); // nice long buffer
	iLabel->ActivateL(); // now ready
	}

void CAppleIIAppView::ConstructViewL()
{
	TRect rect=Rect(); // get our rect
	//rect.iBr.iY-=KLabelHeight; // make way for label
	//TPoint center = rect.Center();
	//TRect viewr(center.iX-280/2, center.iY-192/2, center.iX+280/2, center.iY+192/2);
	TRect viewr(144, 24, 144+280, 24+192);
	iView=new (ELeave) CAppleIIView(this, viewr, iModel);
	iView->ConstructL();
}

void CAppleIIAppView::NotifyStatus(const TDesC& aMessage)
	{
	iLabel->SetTextL(aMessage);
	iLabel->DrawNow();
	}

TKeyResponse CAppleIIAppView::OfferKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType)
    {
	if (aType == EEventKey)
	{
		TInt iCode = aKeyEvent.iCode;
		if (iCode > 0x7F)
		{
			switch (iCode)
			{
			case EKeyLeftArrow: iCode = 8; break;
			case EKeyRightArrow: iCode = 21; break;
			case EKeyUpArrow: iCode = 11; break;
			case EKeyDownArrow: iCode = 10; break;
			default:
				return EKeyWasNotConsumed;
			}

		}
		iModel->pressKey(iCode);
		return EKeyWasConsumed;
	} else {
		return EKeyWasNotConsumed;
	}
	/*
	if	(iView)
   		return iView->OfferKeyEventL(aKeyEvent,aType);
	else
	*/
    }

void CAppleIIAppView::Draw(const TRect& /*aRect*/) const
	{
	CWindowGc& gc = SystemGc();
	gc.SetPenStyle(CGraphicsContext::ENullPen);
	gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
	gc.DrawRect(Rect());
	TPoint pos = TPoint(0,0);
	gc.BitBlt(pos, iBackgroundBitmap);
	}

//
// CAppleIIAppUi
//

const TInt PAUSE_USER  = 1;
const TInt PAUSE_FOCUS = 2;

void CAppleIIAppUi::ConstructL()
{
    BaseConstructL();
	((CAppleIIDocument*)iDocument)->NewDocumentL();
	iModel=((CAppleIIDocument*)iDocument)->Model();
	((CAppleIIDocument*)iDocument)->SetupDocumentL();

	// set up default dir
	iImagesDir = TFileName(_L("C:\\"));
	iPowerOn = true;
	iPauseState = 0; /* not paused */

	// create the app view
    iAppView=new(ELeave) CAppleIIAppView;
    iAppView->ConstructL(ClientRect(),iModel);
	//iAppView->NotifyStatus(_L("initialized"));
	// start the screen refresh
	iAppView->StartUpdate(150000);
	// add app view to stack; enables key event handling.
	AddToStackL(iAppView);

	// start the CPU
	iCPUHandler=new(ELeave) CAppleIICPURunner(iModel);
	iCPUHandler->Start(1000000);
}

void CAppleIIAppUi::RunBenchmark()
{
	CEikonEnv* eenv = CEikonEnv::Static();
	if (eenv->QueryWinL(R_BENCHMARK_CONFIRM_1,R_BENCHMARK_CONFIRM_2))
	{
		eenv->BusyMsgL(R_BENCHMARK_RUNNING);
		iModel->setupBenchmark();
		TTime time1, time2;
		time1.UniversalTime();
		iModel->execute(10000000);
		time2.UniversalTime();
		TInt64 timel = time2.MicroSecondsFrom(time1).Int64();
		float clkrate = 10000000.0f/timel.GetTInt();
		eenv->BusyMsgCancel();
		TBuf<40> msg;
		TBuf<40> fmt;
		eenv->ReadResource(fmt, R_BENCHMARK_MAXCLOCK);
		msg.Format(fmt, clkrate);
		eenv->ReadResource(fmt, R_BENCHMARK_DONE);
		eenv->InfoWinL(fmt, msg);
		iModel->hardReset();
	}
}

void CAppleIIAppUi::OpenDiskImageL(int drivenum)
{
	CEikFileOpenDialog* dialog=new(ELeave) CEikFileOpenDialog(&iImagesDir);
	if (dialog->ExecuteLD(R_EIK_DIALOG_FILE_OPEN))
	{
		((CAppleIIDocument*)Document())->DoOpenDiskImageL(iImagesDir, drivenum);
		//HandleModelChangeL();
	}
}

void CAppleIIAppUi::SetPauseL(TInt aPauseState)
{
	if ((aPauseState == 0) != (iPauseState == 0))
	{
		iPauseState = aPauseState;
		DoPauseStateChangeL();
	} else {
		iPauseState = aPauseState;
	}
}

void CAppleIIAppUi::DoPauseStateChangeL()
{
	CEikonEnv* eenv = CEikonEnv::Static();
	TBuf<10> btntext;
	if (iPauseState)
	{
		iAppView->StopUpdate();
		iCPUHandler->Stop();
		eenv->ReadResource(btntext, R_CONTINUE);
	} else {
		iAppView->StartUpdate(100000);
		iCPUHandler->Start(1000000);
		eenv->ReadResource(btntext, R_PAUSE);
	}
	CEikCommandButton* btn = (CEikCommandButton*)iToolBar->ControlById(EApplePause);
	btn->SetTextL(btntext);
	btn->DrawNow();
}

void CAppleIIAppUi::HandleCommandL(TInt aCommand)
	{
	switch (aCommand)
		{
	case EAppleReset:
		iModel->reset();
		return;
	case EAppleHardReset:
		iModel->hardReset();
		return;
	case EApplePause:
		SetPauseL(iPauseState ^ PAUSE_USER);
		return;
	case EAppleOpenDrive1:
		OpenDiskImageL(0);
		return;
	case EAppleOpenDrive2:
		OpenDiskImageL(1);
		return;
	case EAppleRunBenchmark:
		RunBenchmark();
		return;
	case EEikCmdHelpAbout:
		iEikonEnv->InfoWinL(R_PSIAPPLE_ABOUT_TITLE, R_PSIAPPLE_VERSION);
		return;
	case EEikCmdExit:
		Exit();
		return;
		}
	}

CAppleIIAppUi::~CAppleIIAppUi()
	{
	if (iAppView)
		delete iAppView;
	delete iCPUHandler;
	}

void CAppleIIAppUi::HandleForegroundEventL(TBool aForeground)
{
	if (aForeground)
	{
		SetPauseL(iPauseState & ~PAUSE_FOCUS);
	} else {
		SetPauseL(iPauseState | PAUSE_FOCUS);
	}
}

//
// CAppleIIDocument
//

CAppleIIDocument::CAppleIIDocument(CEikApplication& aApp)
	: CEikDocument(aApp) 
{ 
}

CAppleIIDocument::~CAppleIIDocument()
{
}

void CAppleIIDocument::SetupDocumentL()
{
	// CODE NEEDS REFINEMENT
	RFs fsSession;
    User::LeaveIfError(fsSession.Connect()); // Connect session
	{
		RFile file;
	    User::LeaveIfError(file.Open(fsSession, _L("C:\\system\\apps\\PsiApple\\apple2.rom"), EFileShareAny));
		TPtr8 iRom(iModel.getROMBase(), 0x3000); 
		User::LeaveIfError(file.Read(iRom));
		file.Close();
	}
	// END LOUSY CODE (sort of)
	fsSession.Close();
	// create the disk controller object
	TAppleDiskII *diskii = new TAppleDiskII(&iModel);
	diskii->getDrive(0)->setDiskProvider(&dp[0]);
	diskii->getDrive(1)->setDiskProvider(&dp[1]);
	iModel.setPeripheral(6, diskii);
	// reset the apple
	iModel.reset();
}

void CAppleIIDocument::DoOpenDiskImageL(const TFileName& aFileName, int aDriveNum)
{
	dp[aDriveNum].OpenFileL(aFileName);
	TAppleDiskII *diskii = (TAppleDiskII*)iModel.getPeripheral(6);
	diskii->getDrive(aDriveNum)->setNewDisk();
}

//
// TEikonDiskProvider
//

TEikonDiskProvider::TEikonDiskProvider()
{ 
	isOpened = false; 
}

TEikonDiskProvider::~TEikonDiskProvider()
{ 
	fDiskImage.Close(); 
	fsSession.Close(); 
}

void TEikonDiskProvider::OpenFileL(const TFileName& aFileName)
{
	if (!isOpened)
		User::LeaveIfError(fsSession.Connect()); // Connect session
	if (isOpened)
		fDiskImage.Close();
    User::LeaveIfError(fDiskImage.Open(fsSession, aFileName, EFileShareExclusive|EFileRead));
	TUint iAtt;
	User::LeaveIfError(fDiskImage.Att(iAtt));
	isWriteProtected = (iAtt & KEntryAttReadOnly) != 0;
	if (!isWriteProtected)
	{
		fDiskImage.Close();
	    User::LeaveIfError(fDiskImage.Open(fsSession, aFileName, EFileShareExclusive|EFileWrite));
	}
	isOpened = true;
}

void TEikonDiskProvider::getTrackData(int track, byte* data)
{
	TPtr8 iDescTrack(iTrack, 0x1000, 0x1000);
	if ((track & 1) == 0)
	{
		TInt pos = 0x1000*(track>>1);
		if (isOpened) 
		{
			if (fDiskImage.Read(pos, iDescTrack) == KErrNone)
			{
				iGCR.nibblizeTrack(254, track>>1, iTrack, data);
			} else {
				// error writing to disk
				CEikonEnv* eenv = CEikonEnv::Static();
				eenv->InfoMsgWithAlignment(EHLeftVTop, R_ERROR_READING_FROM_DRIVE);
			}
		} else {
			// disk not in drive
			CEikonEnv* eenv = CEikonEnv::Static();
			eenv->InfoMsgWithAlignment(EHLeftVTop, R_NO_DISK_IN_DRIVE);
			Mem::Fill(data, TRACK_SIZE, 0xff);
		}
	}
}

void TEikonDiskProvider::setTrackData(int track, byte* data)
{
	TPtr8 iDescTrack(iTrack, 0x1000, 0x1000);
	if ((track & 1) == 0)
	{
		if (isOpened && 
			iGCR.denibblizeTrack(254, track>>1, data, iTrack))
		{
			//fDiskImage.Write(143352, _L("KRAP"));
			TInt pos = 0x1000*(track>>1);
			if (fDiskImage.Write(pos, iDescTrack) != KErrNone)
			{
				// error writing to disk
				CEikonEnv* eenv = CEikonEnv::Static();
				eenv->InfoMsgWithAlignment(EHLeftVTop, R_ERROR_WRITING_TO_DRIVE);
			}
		} else {
			// error writing to disk
			CEikonEnv* eenv = CEikonEnv::Static();
			eenv->InfoMsgWithAlignment(EHLeftVTop, R_ERROR_CONVERING_TRACK);
		}
	}
}

int TEikonDiskProvider::getIsWriteProtected()
{
	return isWriteProtected;
}

CEikAppUi* CAppleIIDocument::CreateAppUiL()
	{
    return(new(ELeave) CAppleIIAppUi);
	}

//
// CAppleIIApplication
//

TUid CAppleIIApplication::AppDllUid() const
	{
	return KUidAppleIIApp;
	}

#pragma data_seg(".E32_UID")
__WINS_UID(0x10000079,0x1000006c,0x1000118D)
#pragma data_seg()

CApaDocument* CAppleIIApplication::CreateDocumentL()
	{
	return new(ELeave) CAppleIIDocument(*this);
	}

//
// EXPORTed functions
//

EXPORT_C CApaApplication* NewApplication()
	{
	return new CAppleIIApplication;
	}

GLDEF_C TInt E32Dll(TDllReason)
	{
	return KErrNone;
	}

